<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object for chart.
H2ReportDao reportDao = new H2ReportDao();
ReportStatsData stats = reportDao.getStats();
ReportChartData requestTrend = reportDao.getRequestTrend();
ReportChartData domainTop = reportDao.getDomainTop(5);
ReportChartData categoryTop = reportDao.getCategoryTop(5);

// Create data access object for blocked list.
RequestDao requestDao = new RequestDao();
requestDao.page = 1;
requestDao.limit = 10;
requestDao.stime = strftimeAdd("yyyyMMddHHmm", 60 * 60 * -12);  // 12 hours ago.
requestDao.etime = strftime("yyyyMMddHHmm");
requestDao.blockFlag = true;

if(isNewLogin() && isFreeJahaslist()){
	warnList.add("We're using free Jahaslist license for 25 users.");
}

// Message check.
checkNewMessage();

// Version check.
checkNewVersion();
%>
<%@include file="include/action_info.jsp"%>

<!-- Google chart -->
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript">
google.load("visualization", "1", {packages:["corechart"]});

// Draw request trend chart.
google.setOnLoadCallback(drawRequestTrend);
function drawRequestTrend() {
	var data = google.visualization.arrayToDataTable([
		["Time", "Request"]
<%
List<String[]> arrList = requestTrend.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TREND FOR 2 HOURS",
		legend: {position: "none"},
	};

	var chart = new google.visualization.AreaChart(document.getElementById("chartRequestTrend"));
	chart.draw(data, options);
}

// Draw block trend chart.
google.setOnLoadCallback(drawBlockTrend);
function drawBlockTrend() {
	var data = google.visualization.arrayToDataTable([
		["Time", "Block"]
<%
arrList = requestTrend.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TREND FOR 2 HOURS",
		legend: {position: "none"},
		colors: ["red"],
	};

	var chart = new google.visualization.AreaChart(document.getElementById("chartBlockTrend"));
	chart.draw(data, options);
}

// Draw domain top chart.
google.setOnLoadCallback(drawDomainTop);
function drawDomainTop() {
	var data = google.visualization.arrayToDataTable([
		["Domain", "Request"]
<%
arrList = domainTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 DOMAINS",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartDomainTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?domain=" + value;
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw domain block chart.
google.setOnLoadCallback(drawDomainBlock);
function drawDomainBlock() {
	var data = google.visualization.arrayToDataTable([
		["Domain", "Block"]
<%
arrList = domainTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 DOMAINS",
		is3D: true,
		slices: {3: {offset: 0.3},},
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartDomainBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&domain=" + value;
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw category top chart.
google.setOnLoadCallback(drawCategoryTop);
function drawCategoryTop() {
	var data = google.visualization.arrayToDataTable([
		["Category", "Request"]
<%
arrList = categoryTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 CATEGORIES",
		is3D: true,
		slices: {3: {offset: 0.3},}
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCategoryTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?category=" + value;
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw category block chart.
google.setOnLoadCallback(drawCategoryBlock);
function drawCategoryBlock() {
	var data = google.visualization.arrayToDataTable([
		["Category", "Block"]
<%
arrList = categoryTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 CATEGORIES",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCategoryBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&category=" + value;
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

</script>
<!-- /Google chart -->

<div class="title">
<%= reportDao.getStime()%> ~ <%= reportDao.getEtime()%>
</div>
<div class="stats">
request-sum = <%= stats.reqSum%>,
request-cnt = <%= stats.reqCnt%>,
block-sum = <%= stats.blockSum%>,
block-cnt = <%= stats.blockCnt%>,
domain = <%= stats.domainCnt%>,
user = <%= stats.userCnt%>,
client-ip = <%= stats.cltIpCnt%>
</div>

<table width="100%" cellpadding="0" cellspacing="0">
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td width="675">
		<div id="chartRequestTrend" class="chart"></div>
	</td>
	<td width="675">
		<div id="chartBlockTrend" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartDomainTop" class="chart"></div>
	</td>
	<td>
		<div id="chartDomainBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartCategoryTop" class="chart"></div>
	</td>
	<td>
		<div id="chartCategoryBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
</table>

<!-- Recently Blocked Request -->
<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="90">&nbsp;Time</td>
		<td width="50" align="center">Count</td>
		<td width="60" align="center">Type</td>
		<td width="400">Domain</td>
		<td width="180">User</td>
		<td width="150">Client IP</td>
		<td width="180">Group</td>
		<td width="180">Policy</td>
		<td width="">Category</td>
	</tr>

<%
List<RequestData> dataList = requestDao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='9' align='center'>No blocked request yet</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	RequestData data = dataList.get(i);

	String categoryLine = data.category;
	if(categoryLine.length() > 30){
		categoryLine = safeSubstring(data.category, 30) + "..";
	}

	if(data.getBlockYn().equals("Y") && data.getReason().contains("category")){
		categoryLine = "<span class='logging-category'>" + categoryLine + "</span>";
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='9'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= data.getCtime()%></td>
		<td align="right"><%= data.cnt%>&nbsp;&nbsp;</td>
		<td align="center"><%= data.getTypeCode()%></td>
		<td><span class="logging-domain"><%= data.domain%></span> <span class="logging-reason"><%= data.getReason()%></span></td>
		<td><%= data.user%></td>
		<td><%= data.cltIp%></td>
		<td><%= data.grp%></td>
		<td><%= data.policy%></td>
		<td title="<%= data.category%>"><%= categoryLine%></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="9"></td></tr>
</table>

<%@include file="include/footer.jsp"%>
