<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(ConfigData data){
	// Redirection IP.
	if (!ParamTest.isValidBlockIp(data.blockRediIp)) {
		errList.add("Invalid block redirection IP.");
		return false;
	}

	// Login, logout domain.
	if (!isValidDomain(data.loginDomain)) {
		errList.add("Invalid login domain.");
		return false;
	}

	if (!isValidDomain(data.logoutDomain)) {
		errList.add("Invalid logout domain.");
		return false;
	}

	// Syslog.
	if (isNotEmpty(data.syslogHost) && !isValidIp(data.syslogHost)) {
		errList.add("Invalid IP address for Syslog host.");
		return false;
	}

	if (data.remoteLogging && isEmpty(data.syslogHost)) {
		errList.add("Remote logging option requires Syslog host.");
		return false;
	}

	// Netflow.
	if (isNotEmpty(data.netflowIp) && !isValidIp(data.netflowIp)) {
		errList.add("Invalid router IP.");
		return false;
	}

	if (data.useNetflow && isEmpty(data.netflowIp)) {
		errList.add("Router IP missing.");
		return false;
	}

	// Misc.
	if (!isValidDomain(data.adminDomain)) {
		errList.add("Invalid admin domain.");
		return false;
	}

	return true;
}

//-----------------------------------------------
void update(ConfigDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	ConfigData oldData = dao.selectOne();
	ConfigData data = new ConfigData();

	// Block and authentication.
	data.blockRediIp = paramString("blockRediIp");
	data.silentBlock = paramBoolean("silentBlock");
	data.enableLogin = paramBoolean("enableLogin");
	data.disableLoginRedirection = paramBoolean("disableLoginRedirection");
	data.loginDomain = paramString("loginDomain");
	data.logoutDomain = paramString("logoutDomain");
	data.loginSessionTtl = paramInt("loginSessionTtl");

	// Syslog.
	data.syslogHost = paramString("syslogHost");
	data.syslogPort = paramInt("syslogPort");
	data.exportBlockedOnly = paramBoolean("exportBlockedOnly");
	data.fromEachNode = paramBoolean("fromEachNode");
	data.syslogJson = paramBoolean("syslogJson");
	data.remoteLogging = paramBoolean("remoteLogging");

	// Netflow.
	data.netflowIp = paramString("netflowIp");
	data.netflowPort = paramInt("netflowPort");
	data.useNetflow = paramBoolean("useNetflow");

	// Misc.
	data.adminDomain = paramString("adminDomain");
	data.bypassMsUpdate = paramBoolean("bypassMsUpdate");
	data.logRetentionDays = paramInt("logRetentionDays");
	data.sslOnly = paramBoolean("sslOnly");

	data.autoBackupDays = paramInt("autoBackupDays");
	data.agentPolicyUpdatePeriod = paramInt("agentPolicyUpdatePeriod");
	data.aQueryOnly = paramBoolean("aQueryOnly");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add("Data updated.");
	}

	if(!oldData.syslogHost.equals(data.syslogHost)
		|| oldData.syslogPort != data.syslogPort
		|| oldData.exportBlockedOnly != data.exportBlockedOnly
		|| oldData.fromEachNode != data.fromEachNode
		|| oldData.remoteLogging != data.remoteLogging
		|| !oldData.netflowIp.equals(data.netflowIp)
		|| oldData.netflowPort != data.netflowPort
		|| oldData.useNetflow != data.useNetflow
	){
		warnList.add("Restarting is required after changing Syslog, NetFlow settings.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
ConfigDao dao = new ConfigDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
ConfigData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>BLOCK AND AUTHENTICATION</legend>
<table class="view">

	<tr>
		<td width="200">Block Redirection IP</td>
		<td><input type="text" name="blockRediIp" value="<%= data.blockRediIp%>" size="50"></td>
	</tr>

	<tr>
		<td>
			Silent Block
			<i class="fa fa-question-circle south-east" title="With this option, there's no block redirection or block page. This is for when you want<br>
			to block a website silently. It also hides the SSL warning from blocking HTTPS request."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="silentBlock"	<%if(data.silentBlock){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Enable Authentication</td>
		<td><input type="checkbox" class="no-border"
			name="enableLogin"	<%if(data.enableLogin){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Login Domain
			<i class="fa fa-question-circle south-east" title="Domain for accessing login page."></i>
		</td>
		<td><input type="text" name="loginDomain" value="<%= data.loginDomain%>" size="50"></td>
	</tr>

	<tr>
		<td>
			Logout Domain
			<i class="fa fa-question-circle south-east" title="Domain for deleting login session."></i>
		</td>
		<td><input type="text" name="logoutDomain" value="<%= data.logoutDomain%>" size="50"></td>
	</tr>

	<tr>
		<td>Login Session TTL</td>
		<td><input type="text" name="loginSessionTtl" size="4" maxlength="4"
			value="<%= data.loginSessionTtl%>"> minutes, 5 ~ 1440</td>
	</tr>

	<tr>
		<td>Disable Login Redirection</td>
		<td><input type="checkbox" class="no-border"
			name="disableLoginRedirection"	<%if(data.disableLoginRedirection){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>SYSLOG</legend>
<table class="view">

	<tr>
		<td width="200">Syslog Host</td>
		<td>
			<input type="text" name="syslogHost" value="<%= data.syslogHost%>" size="50"
				class="east" title="Restarting is required after changing Syslog settings.">
		</td>
	</tr>

	<tr>
		<td>Syslog Port</td>
		<td><input type="text" name="syslogPort" size="4" maxlength="4"
			value="<%= data.syslogPort%>"></td>
	</tr>

	<tr>
		<td>Export Blocked Only</td>
		<td><input type="checkbox" class="no-border"
			name="exportBlockedOnly" <%if(data.exportBlockedOnly){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			From Each Node
			<i class="fa fa-question-circle south-east" title="In clustering, Syslog will be sent through master node at default.
				<br>With this option enabled, each node sends Syslog on its own."></i>
		</td>
		<td>
			<span class="east" title="Only for when you use clustering.">
				<input type="checkbox" class="no-border"
					name="fromEachNode" <%if(data.fromEachNode){out.print("checked");}%>>
			</span>
			</td>
	</tr>

	<tr>
		<td>Use JSON Format</td>
		<td><input type="checkbox" class="no-border"
			name="syslogJson" <%if(data.syslogJson){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Enable Remote Logging</td>
		<td><input type="checkbox" class="no-border"
			name="remoteLogging" <%if(data.remoteLogging){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>NETFLOW</legend>
<table class="view">

	<tr>
		<td width="200">Router IP</td>
		<td>
			<input type="text" name="netflowIp" value="<%= data.netflowIp%>" size="50"
				class="east" title="Restarting required after changing NetFlow settings.">
		</td>
	</tr>

	<tr>
		<td>Listen Port</td>
		<td><input type="text" name="netflowPort" value="<%= data.netflowPort%>" size="2"></td>
	</tr>

	<tr>
		<td>Run Collector</td>
		<td><input type="checkbox" class="no-border"
			name="useNetflow" <%if(data.useNetflow){out.print("checked");}%>>
			</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>MISC</legend>
<table class="view">

	<tr>
		<td width="200">
			Admin Domain
			<i class="fa fa-question-circle south-east" title="Domain for accessing admin GUI."></i>
		</td>
		<td><input type="text" name="adminDomain" value="<%= data.adminDomain%>" size="50"></td>
	</tr>

	<tr>
		<td>Log Retention Days</td>
		<td><input type="text" name="logRetentionDays" size="2" maxlength="3"
			value="<%= data.logRetentionDays%>"> days, 0 ~ 400</td>
	</tr>

	<tr>
		<td>SSL Only to Admin GUI</td>
		<td><input type="checkbox" class="no-border"
			name="sslOnly" <%if(data.sslOnly){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Auto Backup</td>
		<td><input type="text" name="autoBackupDays" size="2" maxlength="2"
			value="<%= data.autoBackupDays%>"> days, 0 ~ 30</td>
	</tr>

	<tr>
		<td>Filter 'A' Query Only
			<i class="fa fa-question-circle south-east" title="Filtering A and AAAA queries only. With this option enabled,<br>
				you can have a smaller traffic database and better performance."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="aQueryOnly" <%if(data.aQueryOnly){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
