<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(CxlogonDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	CxlogonData data = new CxlogonData();

    data.cxlogonGrpId = paramInt("cxlogonGrpId");
    data.cxlogonAddNew = paramBoolean("cxlogonAddNew");

	// Validate and update it.
	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
CxlogonDao dao = new CxlogonDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
CxlogonData data = dao.selectOne();
List<GroupData> gGroupList = new GroupDao().selectListUserCreatedOnly();
%>
<%@include file="include/action_info.jsp"%>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>CXLOGON</legend>
<table class="view">

	<tr>
		<td colspan="2">
<div style="line-height: 20px">
CxLogon is a single sign-on agent for NxFilter.
</div>
		</td>
	</tr>

	<tr>
		<td width="200">
			Auto-register for New User
			<i class="fa fa-question-circle south-east" title="Adding new users by CxLogon login request automatically."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="cxlogonAddNew" <%if(data.cxlogonAddNew){out.print("checked");}%>>
			</td>
	</tr>

	<tr>
		<td>Default Group for New User</td>
		<td>
		<%
		out.println("<select name='cxlogonGrpId'>");
		out.println("<option value='0'>anon-grp");

		for(GroupData grp : gGroupList){
			if(grp.id == data.cxlogonGrpId){
				printf("<option value='%s' selected>%s\n", grp.id, grp.name);
			}
			else{
				printf("<option value='%s'>%s\n", grp.id, grp.name);
			}
		}

		out.println("</select>");
		%>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
