<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(UserDao dao){
	String usernames = paramString("usernames");
	int grpId = paramInt("grpId");
	String description = paramString("description");

	String[] arr = usernames.split("\\s+");
	for(String a : arr){
		UserData data = new UserData();
		data.name = a;
		data.grpId = grpId;
		data.massFlag = true;
		data.description = description;

		// Param validation.
		if(!ParamTest.isValidNameLen(data.name)){
			errList.add(ParamTest.ERR_NAME_LEN + " - " + data.name);
			break;
		}
		
		if(!ParamTest.isValidUsernameChar(data.name)){
			errList.add(ParamTest.ERR_USERNAME_CHAR + " - " + data.name);
			break;
		}

		if (ParamTest.isDupUser(data.name)) {
			continue;
		}

		if(!dao.insert(data)){
			errList.add("Couldn't add a user! - " + data.name);
			break;
		}
	}

	// Reload user dictionary.
	dao.reloadUserDic();

	if(errList.size() > 0){
		return;
	}

	succList.add("Data updated.");
}

//-----------------------------------------------
void delete(UserDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.deleteMassImportedUsers()){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
UserDao dao = new UserDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}

// Get policy list.
List<GroupData> gGroupList = new GroupDao().selectListUserCreatedOnly();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionDelete(form){
	if(!confirm("Deleting mass imported users.")){
		return;
	}

	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="insert">

<fieldset>
	<legend>MASS IMPORT</legend>
<table class="view">

	<tr>
	<tr>
		<td width="200" valign="top">
			Usernames
			<i class="fa fa-question-circle south-east" title="You can create new users en masse by importing usernames
				<br>separated by spaces."></i>
		</td>
		<td>
			<textarea name="usernames" cols="80" rows="8"></textarea>
		</td>
	</tr>
	</tr>

	<tr>
		<td>Description</td>
		<td>
			<input type="text" name="description" size="50">
		</td>
	</tr>

	<tr>
		<td>Group, Member of</td>

		<td>
			<select name='grpId'>
				<option value='0'>anon-grp
				<%
				for(GroupData grp : gGroupList){
					printf("<option value='%s'>%s\n", grp.id, grp.name);
				}
				%>
			</select>
		</td>

	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="DELETE MASS IMPORTED USERS" onclick="javascript:actionDelete(this.form);">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
